/* Copyright (C) 1999 Lucent Technologies */
/* Excerpted from 'The Practice of Programming' */
/* by Brian W. Kernighan and Rob Pike */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>

#include "csv.h"

enum { NOMEM = -2 };          /* Sygna braku pamici */

static char *line    = NULL;  /* Znaki wejciowe */
static char *sline   = NULL;  /* Kopia wiersza uywana przez funkcj split */
static int  maxline  = 0;     /* Rozmiar tablic line[] i sline[] */
static char **field  = NULL;  /* Wskaniki na pola */
static int  maxfield = 0;     /* Rozmiar tablicy field[] */
static int  nfield   = 0;     /* Liczba pl w tablicy field[] */

static char fieldsep[] = ","; /* Znaki oddzielajce pola */

static char *advquoted(char *);
static int split(void);

/* endofline: sprawdza i usuwa znaki \r, \n, \r\n oraz EOF */
static int endofline(FILE *fin, int c)
{
    int eol;

    eol = (c=='\r' || c=='\n');
    if (c == '\r') {
        c = getc(fin);
        if (c != '\n' && c != EOF)
            ungetc(c, fin);	/* Wczytano za duo, cofnicie c */
    }
    return eol;
}

/* reset: Przywraca wartoci pocztkowe zmiennym */
static void reset(void)
{
    free(line);	/* Wywoanie free(NULL) jest dozwolone w standardzie ANSI C */
    free(sline);
    free(field);
    line = NULL;
    sline = NULL;
    field = NULL;
    maxline = maxfield = nfield = 0;
}

/* csvgetline:  pobiera jeden wiersz, zwiksza tablic w razie potrzeby */
/* Przykadowe dane wejciowe: "LU",86.25,"11/4/1998","2:19PM",+4.0625 */
char *csvgetline(FILE *fin)
{	
    int i, c;
    char *newl, *news;

    if (line == NULL) {			/* Alokacja przy pierwszym wywoaniu */
        maxline = maxfield = 1;
        line = (char *) malloc(maxline);
        sline = (char *) malloc(maxline);
        field = (char **) malloc(maxfield*sizeof(field[0]));
        if (line == NULL || sline == NULL || field == NULL) {
            reset();
            return NULL;		/* Wyczerpanie pamici */
        }
    }
    for (i=0; (c=getc(fin))!=EOF && !endofline(fin,c); i++) {
        if (i >= maxline-1) {	/* Powikszenie wiersza */
            maxline *= 2;		/* Podwojenie aktualnego rozmiaru */
            newl = (char *) realloc(line, maxline);
            if (newl == NULL) {
                reset();
                return NULL;
            }
            line = newl;
            news = (char *) realloc(sline, maxline);
            if (news == NULL) {
                reset();
                return NULL;
            }
            sline = news;


        }
        line[i] = c;
    }
    line[i] = '\0';
    if (split() == NOMEM) {
        reset();
        return NULL;			/* Wyczerpanie pamici */
    }
    return (c == EOF && i == 0) ? NULL : line;
}

/* split: dzieli wiersze na pola */
static int split(void)
{
    char *p, **newf;
    char *sepp; /* Wskanik na tymczasowy znak oddzielajcy */
    int sepc;   /* Tymczasowy znak oddzielajcy */

    nfield = 0;
    if (line[0] == '\0')
        return 0;
    strcpy(sline, line);
    p = sline;

    do {
        if (nfield >= maxfield) {
            maxfield *= 2;			/* Podwojenie aktualnego rozmiaru */
            newf = (char **) realloc(field, 
                        maxfield * sizeof(field[0]));
            if (newf == NULL)
                return NOMEM;
            field = newf;
        }
        if (*p == '"')
            sepp = advquoted(++p);	/* Pominicie pierwszego cudzysowu */
        else
            sepp = p + strcspn(p, fieldsep);
        sepc = sepp[0];
        sepp[0] = '\0';				/* Zakoczenie pola */
        field[nfield++] = p;
        p = sepp + 1;
    } while (sepc == ',');

    return nfield;
}

/* advquoted: pole w cudzysowie; zwraca wskanik na nastpny znak oddzielajcy */
static char *advquoted(char *p)
{
    int i, j;

    for (i = j = 0; p[j] != '\0'; i++, j++) {
        if (p[j] == '"' && p[++j] != '"') {
            /* Kopiuje do napotkania nastpnego znaku oddzielajcego lub znaku \0 */
            int k = strcspn(p+j, fieldsep);
            memmove(p+i, p+j, k);
            i += k;
            j += k;
            break;
        }
        p[i] = p[j];
    }
    p[i] = '\0';
    return p + j;
}

/* csvfield:  zwraca wskanik na n-te pole */
char *csvfield(int n)
{
    if (n < 0 || n >= nfield)
        return NULL;
    return field[n];
}

/* csvnfield:  zwraca licznik pl */ 
int csvnfield(void)
{
    return nfield;
}

/* main: testuje bibliotek CSV */
int main(void)
{
    int i;
    char *line;

    while ((line = csvgetline(stdin)) != NULL) {
        printf("line = `%s'\n", line);
        for (i = 0; i < csvnfield(); i++)
            printf("field[%d] = `%s'\n", i, csvfield(i));
    }
    return 0;
}
